# Guía de estilo para desarrollo en React con TS

## TL;DR

Instala ESLint y Prettier, utiliza las reglas de lint suministradas y el default de Prettier.

Escribe código para humanos. La legibilidad y sostenibilidad son más importantes que la concisión pues el objetivo es que cualquier persona pueda entender el código rápidamente.

Gestiona las dependencias de forma responsable y prioriza la accesibilidad partiendo de estructurar un HTML semántico. En TypeScript no des lugar a `any`; preferiere `unknown` y la validación de tipos. En React, escribe componentes de Función con una sola responsabilidad y escribe el JSX libre de lógica compleja...

Maneja los errores de forma explícita, para ofrecer una buena experiencia de desarrollo a tus compañeros y una experiencia de usuario robusta.

## Índice de Contenidos

1. [Introducción](./front/1-introduccion.md)
2. [Configuración del Entorno](./front/2-configuracion-del-entorno.md)
    - [Herramienta de Formato](./front/2-configuracion-del-entorno.md#herramienta-de-formato)
    - [La seguridad antes que la policía](./front/2-configuracion-del-entorno.md#la-seguridad-antes-que-la-policía)
3. [Convenciones Generales](./front/3-convenciones-generales.md)
    - [Orden del código](./front/3-convenciones-generales.md#orden-del-código)
    - [Una línea, una acción](./front/3-convenciones-generales.md#una-línea-una-acción)
    - [Nomenclatura](./front/3-convenciones-generales.md#nomenclatura)
    - [Bibliotecas Externas](./front/3-convenciones-generales.md#bibliotecas-externas)
    - [Accesibilidad](./front/3-convenciones-generales.md#accesibilidad)
    - [El texto de la interfaz de usuario](./front/3-convenciones-generales.md#el-texto-de-la-interfaz-de-usuario)
    - [Comentarios solo cuando el código no lo explica todo](./front/3-convenciones-generales.md#comentarios-solo-cuando-el-código-no-lo-explica-todo)
    - [Aduana: Importaciones y exportaciones](./front/3-convenciones-generales.md#aduana-importaciones-y-exportaciones)
4. [Buenas Prácticas en TypeScript](./front/4-buenas-practicas-en-typescript.md)
    - [Explicar lo suficiente](./front/4-buenas-practicas-en-typescript.md#explicar-lo-suficiente)
    - [Interfaces y Tipos: ¿Cuál y cuándo?](./front/4-buenas-practicas-en-typescript.md#interfaces-y-tipos-cuál-y-cuándo)
    - [Arrays y Genéricos](./front/4-buenas-practicas-en-typescript.md#arrays-y-genéricos)
    - [Archivos de definición de tipos](./front/4-buenas-practicas-en-typescript.md#archivos-de-definición-de-tipos)
    - [Vamo' a calmarno'](./front/4-buenas-practicas-en-typescript.md#vamo-a-calmarno)
    - [Constantes con enums y posibilidades con literales](./front/4-buenas-practicas-en-typescript.md#constantes-con-enums-y-posibilidades-con-literales)
    - [`any`, `unknown` y `never`](./front/4-buenas-practicas-en-typescript.md#any-unknown-y-never)
    - [Helpers y Tipos utilitarios](./front/4-buenas-practicas-en-typescript.md#helpers-y-tipos-utilitarios)
5. [Buenas Prácticas en React](./front/5-buenas-practicas-en-react.md)
    - [Componentes de función: La preferencia del equipo](./front/5-buenas-practicas-en-react.md#componentes-de-función-la-preferencia-del-equipo)
    - [Estructura y Organización](./front/5-buenas-practicas-en-react.md#estructura-y-organización)
    - [Props: Cómo pasar y gestionar propiedades](./front/5-buenas-practicas-en-react.md#props-cómo-pasar-y-gestionar-propiedades)
    - [Manejo de estados: Estrategias claras](./front/5-buenas-practicas-en-react.md#manejo-de-estados-estrategias-claras)
    - [Sincronización (`useEffect`)](./front/5-buenas-practicas-en-react.md#sincronización-useeffect)
    - [useMemo y useCallback](./front/5-buenas-practicas-en-react.md#usememo-y-usecallback)
    - [Código ordenado](./front/5-buenas-practicas-en-react.md#código-ordenado)
    - [Fragmentos y Portales](./front/5-buenas-practicas-en-react.md#fragmentos-y-portales)
    - [Handlers (Funciones para manejar eventos de usuario)](./front/5-buenas-practicas-en-react.md#handlers-funciones-para-manejar-eventos-de-usuario)
    - [Seguridad y Buenas prácticas](./front/5-buenas-practicas-en-react.md#seguridad-y-buenas-prácticas)
    - [Manejo de errores](./front/5-buenas-practicas-en-react.md#manejo-de-errores)
6. El CSS deja de ser tan feo cuando lo entiendes (guía en desarrollo)

---
[Siguiente: Introducción](./1-introduccion.md)
