# 🔐 Keycloak Setup – Monitoreo Comunitario

Este documento describe cómo desplegar una instancia local de **Keycloak con PostgreSQL** usando Docker, y configurar el entorno para pruebas de autenticación basadas en OAuth2/OIDC.

---

## 🧱 Requisitos

- Docker y Docker Compose instalados en tu máquina.
- Navegador para acceder a la consola de administración.
- Postman o `curl` para probar autenticación.

---

## 📦 Paso 1: Crear carpeta para colocar los archivos

```bash
mkdir keycloak-monitoreo
cd keycloak-monitoreo
```

---


## 🚀 Paso 2: Levantar Keycloak

```bash
docker compose up -d
```

Accede a:  
👉 [http://localhost:8181](http://localhost:8181)  
Login:  
- Usuario: `admin`  
- Contraseña: `admin`

---

## 🔧 Paso 3: Configurar Keycloak

### 3.1 Crear Realm

#### ¿Para qué sirve un "Realm"?

Un **Realm** en Keycloak es un espacio de aislamiento lógico para gestionar usuarios, roles, grupos y clientes de forma independiente.

Cada realm tiene:
- Su propia base de usuarios (no se comparten entre realms).
- Su propia configuración de autenticación, temas visuales y políticas de sesión.
- Sus propios clientes (aplicaciones) y roles.

🔸 Puedes pensar en un realm como un “entorno” o “dominio” separado.  
🔸 Útil para multitenencia: por ejemplo, tener un realm por cliente, proyecto o ambiente (desarrollo, QA, producción).

En este caso, se crea un realm llamado `monitoreo` para contener la configuración exclusiva del módulo de Monitoreo Comunitario.



1. Inicia sesión con las credenciales de administrador (definidas en el archivo `.env` o en el `docker-compose.yml`).
2. Al iniciar sesión, serás redirigido al **panel de administración**.
3. Desde el menú lateral izquierdo:
   - Haz clic en el botón **"Realm selector"** en la parte superior izquierda (dice `Master` por defecto).
   - Luego haz clic en **"Create realm"** o **"Crear realm"**.
   - Asigna el nombre `monitoreo` y guarda.

> Esto crea un Realm exclusivo para la configuración del módulo.


---

### 3.2 Crear Roles

1. Dentro del realm `monitoreo`, ir a **Roles → Add Role**
2. Crear los siguientes roles:
   - `user`
   - `admin`

---

### 3.3 Crear Usuarios de prueba

#### Usuario `user_demo`:
1. **Users → Add User**
2. Username: `user_demo`
3. Rellenar campos obligatorios:
   - Email: `user@example.com`
   - First Name: Juan
   - Last Name: Pérez
   - Marcar `Enabled: ON`
4. En pestaña **Credentials**:
   - Contraseña: `demo123`
   - Desactivar `Temporary`
   - Clic en `Set Password`
5. En **Role Mappings**: asignar rol `user`

#### Usuario `admin_demo`:
1. Repetir pasos con:
   - Username: `admin_demo`
   - Contraseña: `demo123`
   - Rol: `admin`

---

### 3.4 Crear Client OAuth2

#### ¿Para qué sirve el "Client ID"?

El **Client ID** es el identificador único de una aplicación cliente dentro de Keycloak. Se utiliza para:

- Identificar la aplicación que está solicitando autenticación.
- Asociar configuraciones específicas de OAuth2/OIDC a esa app.
- Usarlo en las peticiones para obtener tokens, junto con el `client_secret`.

🔸 Por ejemplo, si defines `Client ID: monitoreo-client`, este será el nombre que deberás enviar al autenticarte desde Postman o tu backend:

```
client_id=monitoreo-client
```

#### ¿Para qué sirve la "Root URL"?

La opción **Root URL** se utiliza para indicar la URL base de la aplicación cliente que usará este cliente OAuth2.

Por ejemplo:

```
Root URL: http://localhost:3000
```

Esto sirve para:

- Definir hacia dónde redireccionar al usuario después de iniciar/cerrar sesión (si no se especifica manualmente).
- Autocompletar campos como `Valid Redirect URIs`, `Web Origins` y `Admin URL`.
- Permitir interacciones seguras entre Keycloak y la app web (CORS).

🔸 Si estás desarrollando una app web que corre en `http://localhost:3000` (como una SPA en React o Vue), se recomienda colocar esa dirección.

🔸 Si no tienes una app web, puedes dejarlo vacío o usar la URL que corresponda a tu entorno.


1. **Clients → Create Client**
2. Client ID: `monitoreo-client`
3. Client Type: `OpenID Connect`
4. Root URL: `http://localhost:3000`
5. Crear

#### En configuración del cliente:
- **Client authentication**: ✅ ON
- **Standard flow**: ✅
- **Direct access grants**: ✅
- **Service account roles**: ✅
- Guardar

#### En pestaña **Credentials**:
- Copiar el **Client Secret**

---

## 🧪 Paso 4: Probar autenticación con Postman o `curl`

### 4.1 Obtener token con `grant_type=password`

```bash
curl -X POST http://localhost:8181/realms/monitoreo/protocol/openid-connect/token \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -d "client_id=monitoreo-client" \
  -d "client_secret=TU_CLIENT_SECRET" \
  -d "grant_type=password" \
  -d "username=user_demo" \
  -d "password=demo123"
```

### 4.2 Verificar token JWT

- Copia el `access_token` y pégalo en [https://jwt.io](https://jwt.io)

---

### 4.3 Obtener un nuevo token usando `refresh_token`

```bash
curl -X POST http://localhost:8181/realms/monitoreo/protocol/openid-connect/token \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -d "client_id=monitoreo-client" \
  -d "client_secret=TU_CLIENT_SECRET" \
  -d "grant_type=refresh_token" \
  -d "refresh_token=EL_REFRESH_TOKEN_OBTENIDO"
```

---

## 📫 Colección de Postman

Se incluye una colección de Postman con ejemplos de autenticación usando el Realm `monitoreo`.

📁 Archivo: [`keycloak-monitoreo.postman_collection.json`](./keycloak-monitoreo.postman_collection.json)

## ✅ Resultado

Con esta configuración ya puedes:

- Autenticar usuarios vía OIDC (`grant_type=password`)
- Obtener y renovar tokens JWT
- Controlar acceso por roles `admin` y `user`
- Usarlo desde Postman, Node.js, Python, etc.

---

## 📌 Notas adicionales

- El puerto externo del PostgreSQL es `5436`, pero Keycloak se conecta por `5432` (interno en la red Docker).
- Puede cambiar el realm, client_id o usuarios según tus necesidades.
- Si recibes `"invalid_grant"` → asegúrese de que el usuario esté habilitado, con contraseña **no temporal**, y sin acciones requeridas pendientes.
