# Normas de desarrollo 📒

¡Este es el corazón de cómo hacemos las cosas! 💖 Aquí tienes una lista de los temas clave que cubrimos para asegurar un desarrollo de software de alta calidad. ¡Vamos a explorarlos! 🚀

- [Documentación](sections/docs.md) 📚 - ¡La documentación es clave!
- [Versionamiento semántico](sections/semantic-versioning.md)🏷️ - ¡Entiende cómo versionamos nuestro software! 📈 Este documento te explicará el sistema de versionamiento semántico para que puedas seguir los cambios y las mejoras.
- [Herramientas y frameworks](sections/tools-and-frameworks.md)  🛠️ - ¡Descubre las herramientas y frameworks que utilizamos! 🤩 Este documento te mostrará las herramientas que te ayudarán a ser más productivo y a escribir código de alta calidad.
- [Marco de trabajo](sections/team-framework.md) 🤝 - ¡Conoce cómo organizamos nuestro trabajo en equipo! 🗓️ Este documento te explicará cómo colaboramos y nos coordinamos para lograr nuestros objetivos.
- [Tareas (tickets)](sections/tickets.md) 🎫 - ¡Aprende cómo gestionamos nuestras tareas! 📝 Este documento te mostrará cómo utilizamos los tickets para organizar y priorizar nuestro trabajo.
- [Versionamiento de código fuente](sections/code-versioning.md) 💾 - ¡Domina el control de versiones! 💪 Este documento te enseñará cómo versionamos nuestro código fuente para mantener un historial de cambios y colaborar de manera segura.

## Secciones pendientes 🚧

¡Aún hay mucho por documentar! 📝

- [Estilo del código](sections/code-style.md) 🎨 - ¡Asegúrate de que tu código sea legible y consistente! 🤓 Este documento te dará las pautas para escribir código limpio y fácil de entender.
- [Registro de eventos (logs)](sections/logs.md) 🪵 - ¡Registra los eventos importantes para facilitar la depuración y el monitoreo!
- [Desarrollo seguro](sections/security.md) 🛡️ - ¡Protege tu aplicación contra vulnerabilidades y ataques!
- [Bases de datos relacionales](sections/relational-dbs.md) 📊 - ¡Asegúrate de que tus bases de datos sean ordenadas, eficientes y seguras!

---
* volver al [inicio](/README.md)
