# Desarrollo seguro

## Recomendaciones generales

* Para los desarrollos, es recomendable guardar tokens, credenciales u otra información sensible por medio de variables de entorno.  
* Nunca se deberán almacenar contraseñas, tokens, claves privadas o cualquier tipo de información sensible en el código fuente.  
* Es obligatorio el uso de gestores de contraseñas para almacenar y compartir datos sensibles entre desarrolladores u otros integrantes del equipo.  
* En el caso de tener que almacenar contraseñas, es obligatorio el cifrado u ocultamiento de la información. Se recomienda el uso de un algoritmo de [hash](https://en.wikipedia.org/wiki/Hash_function) junto con una [sal](https://en.wikipedia.org/wiki/Salt_\(cryptography\)).  
* En el caso de tener que almacenar datos sensibles (Por ejemplo, números de tarjetas de cŕedito), se deberá utilizar un algoritmo de cifrado robusto (por ejemplo, [AES](https://en.wikipedia.org/wiki/Advanced_Encryption_Standard)) con una clave de al menos 128 bits.

## Recomendaciones (Web)

* Todos los sistemas de información deberán implementar un sistema de [registro de eventos (logs)](logs.md).
* Todas las conexiones y manejo de credenciales y datos sensibles deben ser responsabilidad del *back end*. Bajo ninguna circunstancia el *front end* debe manejar directamente este tipo de datos.  
* Los sistemas de autenticación deberán implementar protecciones ante ataques de [fuerza bruta](https://en.wikipedia.org/wiki/Brute-force_attack).  
* Es recomendable que los sistemas de autenticación implementen un sistema de detección de robots del lado del servidor.  
* Es recomendable habilitar sistemas de doble verificación (por ejemplo, [TOTP](https://en.wikipedia.org/wiki/Time-based_one-time_password)) en los sistemas de autenticación.  
* Las restricciones y permisos de los roles de usuario en el sistema deberán funcionar en el front end y en el back end por igual.  
* Los desarrollos web tendrán que estar preparados para ataques [XSS](https://developer.mozilla.org/en-US/docs/Glossary/Cross-site_scripting), [CSRF](https://developer.mozilla.org/en-US/docs/Glossary/CSRF) y [SQL Injection](https://developer.mozilla.org/en-US/docs/Glossary/SQL_Injection).  
* Todas las plataformas web del ambiente de producción tendrán que implementar protocolos de comunicación cifrados (Por ejemplo, *HTTPS*).

## Recomendaciones (Redes y conexiones)

* Las conexiones a servidores *Linux* en producción deberán realizarse con claves privadas.  
* Se recomienda que las conexiones a sistemas privados y servicios de pruebas se realicen con una conexión por *VPN*.  
* Se recomienda que las conexiones a los servidores sean restringidas por IP pública, en caso de que los servidores pertenezcan a un servicio en la nube privado.