# Versionamiento semántico

Esta sección es de vital importancia cuando corresponde hacer un deploy de alguna de las plataformas desarrolladas por el equipo.

Para el versionamiento de proyectos de software, seguimos las especificaciones del [Versionamiento Semántico](https://semver.org).

##  Especificación

* Un número de versión deberá tener el formato **X.Y.Z** en donde **X**, **Y** y **Z** son números enteros no negativos y no deben ser precedidos de ceros.
* Cada elemento debe incrementarse numéricamente.
* En el formato **X.Y.Z**:
    * El número **X** indicará un número de versión mayor, corresponde a cambios que no tienen compatibilidad con versiones anteriores (por ejemplo, un cambio completo de una API)
    * El número **Y** indicará un número de versión menor, indica cambios compatible con versiones anteriores (por ejemplo, nuevas características o ajustes de bugs no prioritarios)
    * El número **Z** indicará un número de parche, lo que se denomina un `hotfix` en inglés.
* Nunca se deberá modificar el contenido de una versión existente. En caso necesario se debe crear una nueva versión.
* Al realizar un lanzamiento nuevo en *GitHub* (*[Release](https://docs.github.com/en/repositories/releasing-projects-on-github/about-releases)*), el título deberá ser el número del lanzamiento (por ejemplo, *1.2.0*)
* Todo lanzamiento de una nueva versión deberá tener una descripción detallada de los cambios en la misma.

---
* volver al [inicio](/README.md)
* volver a las [normas de desarrollo](/docs/development-rules/README.md)
