# Marco de trabajo

En la línea de informática de la biodiversidad aplicamos una versión de *[SCRUM](https://en.wikipedia.org/wiki/Scrum_(software_development))* adaptada a las necesidades del equipo.

## Estimación de tareas

La estimación de tareas se realiza con "*story points*", para lo cual se tiene una equivalencia entre rangos de tiempo y "*story points*".

**Nota:** Un día es representado por 6 horas efectivas de trabajo.

| Puntos | Tiempo |
| :---: | :---: |
| 1 | Hasta medio día |
| 2 | Hasta un día |
| 3 | Hasta día y medio |
| 5 | Hasta dos días |
| 8 | Hasta tres días |
| (\*) Más de 8  | Se deberá dividir la tarea |

## Ceremonias

### Cierre y planeación de sprint

Los *sprints* duran 2 semanas, iniciando los miércoles. El día de inicio se realizará, en el mismo espacio el cierre y la planeación. El líder técnico es quien se encarga de priorizar y organizar las tareas para cada *sprint* previo a la ceremonia, cada miembro del equipo revisará las tareas. Durante la ceremonia cada persona presentará las tareas asignadas, resolverá dudas y participará en las presentaciones de los demás miembros.

### Daily

El *daily meeting* se realizará de forma asíncrona en la plataforma *[DailyBot](https://app.dailybot.com/checkins/bfe64453-2b94-4ea5-b811-eb70b8ea1181/daily-report/2025-06-25)* por medio de un bot en el chat del *Workspace* de *Google*. Es responsabilidad de cada persona informar en las primeras horas de la mañana las tareas que haya realizado el anterior día laboral y las tareas que vaya a realizar en el día actual. El bot cuenta con un recordatorio y se espera que esto se haga antes de las 9:30 de la mañana.

### Planning

Durante el *planning* se realizan las siguientes actividades:

1. Se revisa la priorización de las tareas. De acuerdo a las consideraciones que tengan los demás miembros del equipo se pueden reorganizar.
2. Por cada tarea:
   1. Se aclaran dudas que no se hayan podido resolver antes de la reunión.
   2. Si la persona que tiene la tarea asignada tiene dudas, se mencionan los puntos de vista de cada miembro y se llega a un consenso sobre la estimación.
   3. Si no se ha asignado un responsable, se asigna.

      **Nota:** algunas tareas, especialmente las *\[spike\]* o *\[poc\]* pueden tener 2 responsables para atacar más de un enfoque en el mismo sprint.

   4. Si la tarea es un *\[spike\]* o un *\[poc\]*, se programa una reunión de seguimiento con al menos otro miembro del equipo (normalmente será el líder técnico y/o alguien que tenga más clara la visión del objetivo de la tarea) a mitad del *sprint* para socializar los avances en la tarea y recibir retroalimentación y orientación.

   1. Se pasa la tarea de la columna *Sprint Backlog* a *Todo*

El tablero debe siempre estar organizado por prioridad, la cual es asignada por el líder técnico o encargado del proyecto

Previo al espacio para el planning se van creando las tareas para revisión en el pipeline *Sprint Backlog*. En caso de que se tengan dudas o comentarios acerca de las tareas o sus estimaciones, se podrán comentar en el chat del grupo (*BioDev*).

En el pipeline *Sprint Backlog* también se dejan las tareas "bonus" del sprint (tareas con prioridad baja que se pueden trabajar si se acaba con la carga del sprint)

**Nota:** Cuando el líder técnico no logra preparar las tareas la semana anterior, es necesario dedicar tiempo al análisis de las tareas en la planeación misma.

### Retrospectiva

Esta ceremonia se realizará en el mismo espacio del *planning*, justo antes de planear las tareas del siguiente sprint.

* Se revisan las tareas que finalizaron. Los responsables explican resumidamente lo que se hizo en la tarea y mencionan cosas que deseen resaltar.
* Las tareas que no se terminaron, es decir, quedaron en estado *In Progress* o *In Review* se agregan al siguiente *sprint*, no se modifica la estimación.


---
* volver al [inicio](/README.md)
* volver a las [normas de desarrollo](/docs/development-rules/README.md)
