# 📦 Configuración de LocalStack para guardar archivos Raster

Este documento explica cómo configurar **LocalStack** localmente para emular S3 y guardar archivos raster (por ejemplo, `.tif`).

---

## ✅ Requisitos

Asegúrate de tener lo siguiente instalado:

- Docker
- Python 3
- Adicional preferible utilizar conda
- Dependencias en `requirements.txt`:

```bash
pip install -r requirements.txt
```

---

## 📂 requirements.txt

```text
boto3        # Librería oficial de AWS para Python. Se usa para interactuar con servicios como S3.
awscli       # Interfaz de línea de comandos para AWS. Permite interactuar con servicios como S3 desde el terminal.
```

---

## 🧱 1. Levantar LocalStack con Docker

Utiliza este `docker-compose.yml`:

```yaml
version: "3.8"

services:
  localstack:
    container_name: "${LOCALSTACK_DOCKER_NAME:-localstack-main}"
    image: localstack/localstack
    ports:
      - "127.0.0.1:4566:4566"
      - "127.0.0.1:4510-4559:4510-4559"
    environment:
      - DEBUG=${DEBUG:-1}
      - SERVICES=${SERVICES:-s3}
      - DOCKER_HOST=unix:///var/run/docker.sock
    volumes:
      - "${LOCALSTACK_VOLUME_DIR:-./volume}:/var/lib/localstack"
      - "/var/run/docker.sock:/var/run/docker.sock"
```

Luego ejecuta:

```bash
docker-compose up -d
```

Esto iniciará LocalStack con el servicio S3 habilitado en `http://localhost:4566`.

---

## 🪣 2. Configurar AWS CLI para usar LocalStack

1. Configura AWS CLI:

```bash
aws configure
```

Puedes usar valores ficticios:

- Access Key ID: `test`
- Secret Access Key: `test`
- Region: `us-east-1`

2. Crea un bucket S3 en LocalStack:

```bash
aws --endpoint-url=http://localhost:4566 s3 mb s3://mi-bucket-raster
```

---

## 🗂️ 3. Subir un archivo raster al bucket

```bash
aws --endpoint-url=http://localhost:4566 s3 cp 2000-2005.tif s3://mi-bucket-raster/
```

---

## 🐍 4. (Opcional) Subir raster con Python (`boto3`)

Se genero un codigo para realizar la prueba de upload del raster desde python.

```
python upload_raster.py

```

---

## 🧪 Verifica el contenido del bucket

```bash
aws --endpoint-url=http://localhost:4566 s3 ls s3://mi-bucket-raster/
```

---

## 🧼 Detener LocalStack

```bash
docker-compose down
```

---

## 📝 Notas adicionales

- LocalStack guarda los datos localmente en `./volume`.
- Puedes emular más servicios de AWS agregándolos a la variable `SERVICES` en el `docker-compose.yml`.

---

## 📥 (Opcional) Consultar y descargar archivos con Python (`boto3`)

Se genero un codigo para realizar la prueba de listar y descargar del raster desde python.

```
python list_and_download_raster.py

```



