import boto3

# Configurar cliente S3 apuntando a LocalStack
s3 = boto3.client(
    "s3",
    endpoint_url="http://localhost:4566",
    aws_access_key_id="test",
    aws_secret_access_key="test",
    region_name="us-east-1"
)

bucket_name = "mi-bucket-raster"
raster_path = "2000-2005.tif"
raster_key = "raster/2000-2005.tif"

# Crear bucket (si no existe)
s3.create_bucket(Bucket=bucket_name)

# Subir archivo
with open(raster_path, "rb") as f:
    s3.upload_fileobj(f, bucket_name, raster_key)

print(f"Archivo subido como s3://{bucket_name}/{raster_key}")
