# Tareas (tickets)

Todo nuevo requerimiento o error de un sistema debe ser debidamente documentado en un sistema de tickets y estar asignado a un integrante del equipo de desarrollo.

## Creación

Todos los miembros del equipo podrán crear tareas cuando sea necesario, las cuales se deberán crear en el repositorio correspondiente. 

A continuación se presenta una guía para determinar en qué pipeline se debería crear:

1. Primero se debe identificar el repositorio adecuado para crear la tarea. Por lo regular, si está relacionada con código, va a haber un repositorio dedicado para el proyecto o producto correspondiente.   
2. Si el ticket es un bug reportado por algún investigador, se agrega al *backlog* con la máxima prioridad.  
3. Si el ticket es una mejora, deberá ir en la sección “*New Issues / Icebox”* con la máxima prioridad.  
4. Si se debe acortar el alcance de una tarea, se agrega en el backlog con la máxima prioridad.  
5. Si es una actividad en la que se tuvo que trabajar sin previo aviso, pero del cuál se debe agregar registro (por ejemplo para poder asociar un PR), se debe agregar en el *sprint backlog* o en la sección “*In Progress*”.

En cuanto al contenido de la tarea, se debe tener en cuenta lo siguiente para su creación:

* Debe tener una descripción que detalle el resultado esperado y las condiciones relacionadas a dicho resultado, esto puede estar acompañado de una lista de puntos para describir todo más fácilmente.  
* Cuando sea necesario, debe haber una sección de “Consideraciones” en donde se deben describir cosas a tener en cuenta para la tarea. Por ejemplo: archivos de prueba, consultas a otros investigadores, ayudas a TI.

Al crear las tareas, se deben asignar las siguientes etiquetas:

* **Prioridad**: Etiquetas diseñadas para enfatizar la prioridad de las tareas: `prio:high` \- `prio:medium` \- `prio:low`  
* **Tipo**: Determinan el impacto de la tarea dentro de la plataforma:  
  `type:bug` \- `type:enhancement` \- `type:feature` \- `type:documentation`

Las tareas asociadas al desarrollo normal de los compromisos de la línea son creadas por el líder técnico. Esto lo hará los últimos días del sprint anterior, de manera que los demás miembros del equipo puedan revisar, entender y dar una estimación inicial a las tareas antes de la reunión de planeación. 

En caso de que se tengan dudas o comentarios acerca de las estimaciones de las tareas, se podrán comentar en el chat del grupo (BioDev).

**Nota:** Cuando el líder técnico no logra preparar las tareas la semana anterior, es necesario dedicar tiempo al análisis de las tareas en la planeación misma.

## Desarrollo y cierre

* Al empezar a trabajar en una tarea, se debe pasar al pipeline “*In Progress*”. La tarea se mantendrá ahí a menos que por diferentes razones no se pueda seguir trabajando en ella, en cuyo caso pasará de nuevo a “*Sprint Backlog*”.   
* Cuando no es necesario realizar una tarea (empezar o terminar), se debe añadir la etiqueta *wontfix*, agregar un comentario describiendo el por qué y cerrarla.  
* Al crear un PR se debe asociar la tarea correspondiente. Esto automáticamente pasará la tarea al pipeline “*Review Q/A*”. De este estado solo vuelve a “*In Progress*” si los cambios solicitados son grandes.  
* Antes de cerrar una tarea se deben dejar comentarios que sean relevantes en el futuro. Por ejemplo, si se tomaron decisiones durante el desarrollo de la misma, discusiones que se hayan tenido, fuentes de información relevantes, modificaciones de alcance, entre otros. No se espera un detalle técnico, a menos que no haya código relacionado en el repositorio (normalmente a través de un PR)  
* Para cerrar una tarea, debe pasar por la aprobación y merge del PR. Si la tarea tiene solo un revisor asociado, debe tener el visto bueno por chat o en reunión por al menos otro miembro del equipo.