# Marco de trabajo

Nuestro equipo opera bajo un marco de trabajo estructurado que incluye una serie de reuniones periódicas. Estas reuniones se agrupan en dos categorías principales: Reuniones de Línea y Reuniones de Planificación (Planning). Las Reuniones de Línea están diseñadas para mantener a todo el equipo al tanto de situaciones generales, proyectos en curso, nuevas tecnologías y cualquier otro tema relevante para el área. Las Reuniones de Planificación se centran en la coordinación del equipo para la estimación, programación e información de las tareas y acciones necesarias.

## Reuniones de Línea

Esta reunión se lleva a cabo todos los martes con el objetivo de informar, discutir y organizar cualquier tema relevante para el equipo y el trabajo. Aunque los puntos a tratar usualmente son propuestos por el líder técnico, cualquier miembro que considere que un tema debe ser abordado colectivamente puede sugerirlo [aquí](https://docs.google.com/document/d/1n9QdkmhVWzgcuhzDjPrbpmRo8TXwGwg0iNmvThwBnuw/edit?usp=sharing), y será incluido en la agenda para su discusión.

## Reuniones de Planificación

En la línea de informática de la biodiversidad aplicamos una versión de *[SCRUM](https://en.wikipedia.org/wiki/Scrum_(software_development))* adaptada a las necesidades del equipo.

### Estimación de tareas

La estimación de tareas se realiza con "*story points*", para lo cual se tiene una equivalencia entre rangos de tiempo y "*story points*".

**Nota:** Un día es representado por 6 horas efectivas de trabajo.

| Puntos | Tiempo |
| :---: | :---: |
| 1 | Hasta medio día |
| 2 | Hasta un día |
| 3 | Hasta día y medio |
| 5 | Hasta dos días |
| 8 | Hasta tres días |
| (\*) Más de 8  | Se deberá dividir la tarea |

### Ceremonias

Las **ceremonias** son reuniones estructuradas que nos permiten sincronizar al equipo, planear el trabajo y revisar el progreso. Su propósito es asegurar una comunicación fluida y la consecución de objetivos.

#### Planificación de Sprint (Planning)

La **Planificación de Sprint** es donde el equipo define qué se va a lograr en el próximo sprint y cómo se va a hacer.

Los *sprints* duran dos semanas y comienzan los miércoles. Antes de esta ceremonia, el líder técnico prioriza y organiza las tareas, y cada miembro del equipo revisa las que le fueron asignadas.

Durante la ceremonia desde su tablero cada participante:

1. **Realiza su retrospectiva individual**: Al inicio de cada sprint, revisa lo completado en el sprint anterior y las nuevas tareas a planear. [Ver Cierre y Retrospectiva.](#cierre-y-retrospectiva-sprint-retrospective)

2. **Prioriza las tareas asignadas**: Se revisa la priorización de las tareas en el *Sprint Backlog*, que también puede incluir tareas "bonus" de baja prioridad (estas se pueden trabajar si se termina la carga principal del sprint). Las tareas pueden reorganizarse según las consideraciones del equipo.

3. **Detalla y estima la duración de cada tarea asignada**:
    - Se aclaran las dudas sobre cada tarea que no se hayan resuelto antes de la reunión.
    - Si la persona asignada tiene dudas sobre la estimación, se discuten los puntos de vista de los miembros del equipo hasta llegar a un consenso sobre el valor de los *story points*.
    - **Nota**: Algunas tareas, como los *[spike]* (investigaciones) o *[PoC]* (pruebas de concepto), pueden tener dos responsables para abordar múltiples enfoques en el mismo sprint. Para estas tareas, se programa una reunión de seguimiento a mitad del sprint con al menos otro miembro del equipo (generalmente el líder técnico o alguien con una visión clara del objetivo), para socializar los avances, recibir retroalimentación y obtener orientación.
    - Una vez detallada y estimada, la tarea se mueve de la columna *Sprint Backlog* a *Todo* en el tablero.

Si una tarea no tiene un responsable, se le asigna uno durante la ceremonia.

El tablero debe estar siempre organizado según la prioridad asignada por el líder técnico o el encargado del proyecto.

**Nota**: Si el líder técnico no logra preparar las tareas la semana anterior, es necesario dedicar tiempo al análisis de las tareas durante la misma sesión de planeación.

#### Diaria (Daily Scrum)

El **Daily Scrum** es una actividad diaria en la que cada persona informa al resto del equipo sobre lo que hizo el día anterior, sus planes para el día actual y los obstáculos que se le han presentado. Esto mantiene al equipo informado sobre el estado del sprint. Se realiza de forma asíncrona a través de un bot en el chat del *Workspace de Google*, utilizando la plataforma *DailyBot*. El bot envía un recordatorio, y se espera que esta actualización se realice antes de las 9:30 a.m.

#### Cierre y Retrospectiva (Sprint Retrospective)

Esta es una ceremonia clave para la mejora continua del equipo y sus procesos. Aquí, reflexionamos sobre el sprint que acaba de terminar, identificando qué funcionó bien, qué se puede mejorar y cómo implementar esos cambios.

La *Retrospectiva* se realiza justo antes de realizar la planeación del siguiente sprint. En ella:

- **Se revisan las tareas finalizadas**: Los responsables explican brevemente lo que se hizo y destacan los puntos relevantes.

- **Se revisan las tareas no finalizadas**: Las tareas que quedaron en estado *In Progress* o *In Review* se trasladan al siguiente sprint sin modificar su estimación original. Esto asegura que el trabajo incompleto no se olvide y se priorice en el próximo ciclo.

---

- volver al [inicio](/README.md)
- volver a las [normas de desarrollo](/docs/development-rules/README.md)
