# Excalidraw

## Qué es?

[Excalidraw](https://excalidraw.com/)([repositorio](https://github.com/excalidraw/excalidraw)) es una pizarra virtual que sirve para agilizar la comunicación visual de ideas. La sencillez de la interfaz ayuda permite crear diagramas, bocetos, maquetas y gráficos rápidamente.

Es una herramienta open source, ligera y fácil de usar que funciona directamente en el navegador. Lo mejor es que se puede integrar dentro de otras aplicaciones, como con este [plugin para Obsidian](https://github.com/zsviczian/obsidian-excalidraw-plugin) o embeber dentro de sitios web desarrollados con React.

Mientras que otras herramientas como Draw.io se destacan por la cantidad de detalles que se pueden controlar y elementos disponibles, **Excalidraw** brilla por su sencillez. Es ideal para aterrizar conceptos un poco abstractos o para la creación de bocetos "en caliente", sesiones de lluvia de ideas, planificación y la creación de mapas mentales, diagramas de flujo y wireframes.

## Cómo funciona?

Aunque es una herramienta bastante intuitiva, [aquí](https://www.youtube.com/watch?v=MayTRZAh0QE&list=PLbFAO-1MUJaU114M2-JOZOHZK8dcGgmbM) puedes encontrar una serie de tutoriales realizados por quienes crearon la herramienta.

## Guardado, exportaciones editables y Git

Excalidraw ofrece varias opciones para guardar y exportar tus diagramas, cada una con un propósito específico, pero todas con la ventaja de facilitar su gestión y versionado.

La principal forma de guardar el trabajo es a través del formato nativo `.excalidraw.` Este es un simple archivo de texto con formato JSON que contiene todos los datos de tu tablero. Es la opción más completa, ya que guarda cada elemento (formas, líneas, texto) de manera individual, permitiendo su total edición al reabrir el archivo.

Además, Excalidraw tiene la capacidad de exportar PNGs y SVGs editables. Para hacerlo, marcamos la casilla "Incrustar escena" en el cuadro de diálogo de exportación. Esto crea un archivo especial que, aunque se ve y comporta como una imagen cualquiera, lleva "escondido" el JSON del diagrama, que, al volver a importarlo en Excalidraw, la herramienta "descompone" la imagen en sus elementos originales, permitiendo su edición.

![exportar un PNG editable](./imgs/exportar.jpg)

### Y con git qué?

La naturaleza de texto del formato `.excalidraw` lo hace perfecto para sistemas de control de versiones como Git. A diferencia de un PNG, que para Git es una caja negra, `.excalidraw` es compatible con el sistema de almacenamiento de cambios de Git. Esto nos permite ver las diferencias entre las versiones del diagrama, la responsabilidad del cambio, identificar exactamente qué elementos se agregaron o eliminaron, y fusionar ramas sin conflictos complejos.

```Diff
--- a/mi_diagrama.excalidraw
+++ b/mi_diagrama.excalidraw 
@@ -2,7 +2,7 @@ 
"elements": [ 
  {
    "type": "rectangle", 
-   "x": 100, 
-   "y": 50, 
+   "x": 120, 
+   "y": 60, 
    "width": 150, 
    "height": 100
  }
]
```

## Creación de diagramas desde código con Mermaid

Excalidraw incluye una herramienta nativa para generar diagramas directamente desde la sintaxis de Mermaid. Para usarla, ve la opción "Mermaid to Excalidraw". Al seleccionarla, se abrirá un editor de texto donde puedes pegar el código Mermaid. Con solo pulsar un botón, Excalidraw interpretará el código y dibujará el diagrama completo sobre el lienzo. En este momento sólo puede hacerlo con "Diagramas de flujo", "Diagramas de secuencia" y "Diagramas de Clases (OOP)"

![Crear diagrama desde mermaid](./imgs/mermaid.jpg)

## Guardar con "Enlace Para Compartir"

Excalidraw permite "guardar" una versión específica de tu tablero generando un enlace único, sin necesidad de crear un archivo local. Esta funcionalidad, a menudo encontrada en el menú de **Exportar**, crea una **versión de solo lectura** de tu trabajo.

Al seleccionarla, Excalidraw captura el estado actual del tablero, lo aloja en sus servidores y proporciona una URL temporal. Cualquier persona con este enlace podrá ver el diagrama o boceto exactamente como lo dejaste, pero no podrá modificar tu versión original, ya que al modificarlo, cambiará el enlace.

![Guardar para compoartir](./imgs/compartir.jpg)

## Importar diagramas desde Draw.io

Si bien Excalidraw no tiene una función para "importar" directamente un archivo de Draw.io, el método más efectivo es utilizar el formato de imagen vectorial SVG como puente. El proceso es sencillo: primero, en Draw.io, debes exportar tu diagrama yendo a `Archivo > Exportar como > SVG`. Una vez que tengas el archivo `.svg` guardado en tu computador, simplemente arrástralo y suéltalo sobre el lienzo de Excalidraw. La herramienta procesará la imagen y la mostrará en tu tablero, permitiéndote integrarla con otros elementos nativos de Excalidraw.

Este proceso **no es una conversión, sino una importación de imagen**. El diagrama de Draw.io aparecerá en Excalidraw como una sola imagen estática y no como elementos editables. Esto significa que no podrás modificar los textos, cambiar de posición las flechas o editar las formas que componían el diagrama original. Por lo tanto, este método sirve para usar diagramas existentes como referencia o para añadir anotaciones rápidas, pero no para continuar editando un diagrama.
