# Bases de datos relacionales

## Recomendaciones generales

* Todas las bases de datos deberán permitir almacenar datos en Español correctamente.  
* Todos los nombres de los elementos de las bases de datos (tablas, columnas, vistas, triggers, etcétera) deberán estar en Inglés.  
* Por temas de versionamiento y actualización de las bases de datos, se recomienda no crear vistas, triggers, funciones ni procedimientos almacenados.  
* Se recomienda el uso de diferentes esquemas (*schemas*) para dividir la base de datos por módulos.

## Desarrollo y versionamiento

Será obligatorio el uso de herramientas *ORM* (*Object Relational Mapping*) para manejar las bases de datos relacionales en proyectos de software.

En caso de no usar otros sistemas de versionamiento, se podrán agregar los cambios de las bases de datos siguiendo las siguientes normas:

* Los scripts SQL se almacenarán en la ruta “*./scripts/sql/*”.  
* Los scripts se guardarán en una carpeta con un formato de nombres que indique la fecha de creación (formato *año-mes-día* seguido de un guión) seguido de una descripción breve en Inglés. Algunos ejemplos son:  
  * *2022-12-31 \- Logs module*  
  * *2023-02-24 \- User module changes*  
* En la carpeta se guardarán los scripts SQL con un formato de nombres que indique el orden (Un entero y un punto) seguido de una breve descripción del script en Inglés. Algunos ejemplos son:  
  * *1\. Update tables.sql*  
  * *2\. Add tables.sql*  
  * *3\. Sedding data.sql*  
* Todos los scripts deberán indicar al inicio, a qué base de datos afectarán (Con el comando *USE*).  
* Todos los scripts deberán estar documentados, describiendo los cambios que realizarán.  
* En los comandos de los scripts deberán especificarse los esquemas (*schemas*) involucrados, sin importar que se esté manejando el esquema por defecto.  
* Se recomienda dividir los scripts por tipo (por ejemplo, scripts para creación de tablas, de poblado de datos, de modificación, etcétera)

## Tablas

Para las bases de datos relacionales, es necesario cumplir con las siguientes condiciones:

* Se debe evitar el uso de tablas temporales.  
* Todas las tablas deberán tener una columna con una llave primaria (*PK*). Se recomienda que sea un identificador numérico.  
* Los nombres de tablas y columnas se tendrán que nombrar en singular.

## Prefijos

Para las bases de datos relacionales, es necesario utilizar los siguientes prefijos:

| Elemento | Prefijo |
| ----- | ----- |
| Procedimiento almacenado | “*sp\_*” |
| Función | “*fn\_*” |
| Trigger | “*tg\_*” |
| Vista | “*vw\_*” |

## Seguridad

Tareas del administrador de bases de datos (*DBA*):

* Es obligatorio el uso de un usuario de base de datos que tenga permisos restringidos únicamente relacionados con el sistema de información.  
* Es obligatorio limitar el privilegio al mínimo necesario.  
* Es obligatorio llevar un control de versiones de la base de datos.  
* En caso de existir un usuario súper administrador en un ambiente de producción, es recomendable eliminarlo.  
* Es recomendable asignar contraseñas robustas a los usuarios de la base de datos.  
* Es recomendable utilizar cifrado en las conexiones con SSL, o usar un túnel SSH.  
* Es obligatoria una revisión periódica del espacio en disco y los logs del sistema.  
* Es obligatorio realizar copias de seguridad periódicamente y probar su correcto funcionamiento.

## Rendimiento

* Evitar el uso de vistas y procedimientos almacenados.  
* Evitar la creación y el uso de columnas con datos binarios.  
* En caso de tener columnas con datos binarios deben estar en tablas separadas referenciadas con la llave primaria, con el fin de mejorar el tiempo en las búsquedas y las copias de seguridad.  
* Evitar usar el asterisco (\*) en las sentencias *SELECT*.  
* Si se van a realizar muchas inserciones o actualizaciones en una tabla, se deben utilizar [tareas por lotes](https://learn.microsoft.com/en-us/sql/odbc/reference/develop-app/batches-of-sql-statements?view=sql-server-ver16).  
* En caso de necesitar una consulta que involucre muchas columnas y/o conversiones de las mismas, se recomienda crear un [campo computado](https://learn.microsoft.com/en-us/sql/relational-databases/tables/specify-computed-columns-in-a-table?view=sql-server-ver16).