# Estructura de proyectos back end

### Proyectos con ASP.NET

Para proyectos en ASP.NET, se ha implementado un patrón de arquitectura inspirado en [Arquitectura en cebolla (onion)](https://medium.com/@alessandro.traversi/understanding-onion-architecture-an-example-folder-structure-9c62208cc97d), siguiendo las recomendaciones de [Microsoft](https://learn.microsoft.com/en-us/dotnet/architecture/modern-web-apps-azure/common-web-application-architectures).

Se recomienda entender el funcionamiento de los siguientes principios y patrones de diseño:

- [Principios SOLID](https://www.digitalocean.com/community/conceptual-articles/s-o-l-i-d-the-first-five-principles-of-object-oriented-design)
- [Patrón DTO (Data Transfer Object)](https://www.baeldung.com/java-dto-pattern)
- [Patrón Repositorio (Repository)](https://medium.com/@pererikbergman/repository-design-pattern-e28c0f3e4a30)
- [Patrón de Inyección de Dependencias (Dependency Injection - DI)](https://www.geeksforgeeks.org/system-design/dependency-injectiondi-design-pattern/)

Este patrón de arquitectura utiliza las siguientes capas:

> Fuente: [milanjovanovic.tech](https://www.milanjovanovic.tech/blog/clean-architecture-folder-structure)

![Onion diagram](/resources/images/architecture-patterns/clean-architecture.png)

Se recomienda que la estructura de carpetas de la solución sea así:

```sh
.
├── .env                # Archivo con variables de entorno
├── *.sln               # Archivo de la solución de .NET
└── src                 # Código fuente
    ├── Application
    ├── Core
    ├── Infrastructure
    └── WebApi
```

#### Proyecto `Core`

Esta capa contiene código del dominio y reglas de negocio que se reutilizan en la solución. Se debe evitar que esta capa tenga dependencias externas.

```sh
src/Core
├── Core.csproj     # Archivo del proyecto de .NET
├── Domain          # Archivos del dominio
│   ├── Constants   # Clases con constantes
│   ├── Entities    # Clases de tipo Entidad
│   ├── Enums       # Clases con enumeraciones
│   └── Utils       # Clases generales que no son ni DTOs ni entidades (objetos planos)
└── Interfaces      # Interfaces generales del sistema
```

#### Proyecto `Application`

Capa en donde se maneja la lógica de negocio para los casos de uso.

> **NOTA:** En esta capa se agregan los `DTOs`, ya que son adaptaciones de los datos que viajan entre el sistema y el exterior (`WebApi`). No se agregan en la capa `Core`, debido a que (usualmente) no es su responsabilidad conocer cómo se van a transformar los datos en capas externas.

```sh
src/Application
├── Application.csproj  # Archivo del proyecto de .NET
├── DTOs                # Clases de tipo DTO
├── Interfaces          # Interfaces generales del sistema
├── Mappings            # Clases para mapeo de entidades y DTOs
├── Services            # Servicios del sistema
├── Specifications      # Especificaciones de consultas en bases de datos
├── Utils               # Utilidades generales del sistema
└── Validators          # Reglas de validaciones de clases
```

#### Proyecto `Infrastructure`

Capa en donde se manejarán conexiones con bases de datos y sistemas externos.

```sh
src/Infrastructure
├── Infrastructure.csproj       # Archivo del proyecto de .NET
├── Integrations                # Archivos de configuración de sistemas externos
└── Persistence                 # Archivos para la base de datos principal (SQL)
    ├── Config                  # Archivos de configuración
    │   ├── DependencyRegistry  # Archivos de configuración para registro de dependencias
    │   └── Entities            # Archivos de configuración de entidades de la base de 
    ├── GeneralContext.cs       # Contexto de base de datos (SQL)
    ├── Migrations              # Migraciones de la base de datos
    └── Repositories            # Repositorios de las entidades
```

#### Proyecto `WebApi`

Capa de presentación

```sh
src/WebApi
├── WebApi.csproj           # Archivo del proyecto de .NET
├── Config                  # Archivos de configuración (registro de dependencias, configuración de complementos, etc ...)
│   ├── DependencyRegistry  # Archivos de configuración para registro de dependencias
│   ├── DocsSetup           # Archivos de configuración del sistema de documentación (Swagger)
│   └── LoggerSetup         # Archivos de configuración del sistema de registros (logs)
├── Controllers             # Controladores del proyecto
│   ├── Rest                # Controladores REST
│   └── Tools               # Controladores personalizados (plantillas de correo electrónico, generadores de documentos, herramientas, etc ...)
├── Interfaces              # Interfaces generales del sistema
├── Program.cs              # Clase principal del proyecto
├── Properties              # Carpeta de propiedades del proyecto (ASP.NET)
└── Utils                   # Utilidades del proyecto
```

* volver al [inicio](/README.md)
* volver a las [normas de desarrollo](/docs/development-rules/README.md)