# Estilo del código

## Convención de nombres (Naming conventions)

Dependiendo del lenguaje, se deberá utilizar la convención de nombres por defecto del mismo. Algunos ejemplos son:

| Lenguaje                     | Convención de nombres                                                                                                    |
| ---------------------------- | ------------------------------------------------------------------------------------------------------------------------ |
| Javascript, Typescript, Java | [camelCase](https://en.wikipedia.org/wiki/Camel_case)                                                                    |
| Python                       | snake\_case y camelCase ([ver](https://peps.python.org/pep-0008/#naming-conventions))                                    |
| Ruby                         | snake\_case y camelCase (ver guía de ruby y guía de RoR)                                                                 |
| SQL                          | [snake\_case](https://en.wikipedia.org/wiki/Snake_case)                                                                  |
| MongoDB                      | camelCase con [variaciones](https://www.mongodb.com/docs/manual/reference/limits/#naming-restrictions)                   |
| C#                           | PascalCase con [variaciones](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/coding-style/identifier-names) |

## Lenguaje de marcado para comentarios

Dependiendo del lenguaje, se deberá documentar el código con el formato por defecto del mismo. Algunos ejemplos son:

| Lenguaje               | Formato                                                                                                |
| ---------------------- | ------------------------------------------------------------------------------------------------------ |
| Javascript, Typescript | [JSDoc](https://jsdoc.app)                                                                             |
| Java                   | [Javadoc](https://docs.oracle.com/javase/8/docs/technotes/tools/windows/javadoc.html)                  |
| Python                 | [Docstring](https://peps.python.org/pep-0008/#documentation-strings)                                   |
| Ruby                   | [RDoc](https://github.com/ruby/rdoc)                                                                   |
| C#                     | [XML Docs](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/xmldoc/recommended-tags) |

**NOTA:** El uso de este tipo de comentarios será obligatorio para clases, interfaces y funciones. Para las funciones, se deberán documentar también los tipos de parámetros y el tipo de retorno si aplica (incluyendo manejo de excepciones)

* volver al [inicio](/README.md)
* volver a las [normas de desarrollo](/docs/development-rules/README.md)