# Registro de eventos (logs)

Para sistemas web, se recomienda implementar un sistema de registro de eventos (logs) con textos en Inglés. Es recomendable que se almacenen en una base de datos no relacional (por ejemplo, MongoDB).

Los datos que debería tener un log son:

| Variable | Consola | Base de datos | Notas |
| ----- | :---: | :---: | :---: |
| Identificador | ❌ | ✔️ |  |
| Hora y fecha | ✔️ | ✔️ |  |
| Registro manual | ❌ | ✔️ | Variable booleana que indica si el log ha sido registrado manualmente o por un *logger*. |
| Tipo de evento | ✔️ | ✔️ | Valores: \[*Verbose*, *Debug*, *Information*, *Warning*, *Error*, *Fatal*\] |
| Descripción | ✔️ | ✔️ | Breve descripción del evento |
| Sistema o Microservicio | ❌ | ✔️ | Ejemplo: *BioTablero-Search*, *BioTablero-Utils*, *BioTablero-Forest* |
| Módulo | ❌ | ✔️ | Ejemplo: *Users*, *Files*, *Maps* |
| Error | ✔️ | ✔️ | Se recomienda mostrar en consola un error con descripción corta, y guardar en la base de datos el error completo |
| Usuario | ❌ | ✔️ | Solo aplica para sistemas con autenticación |
| IP | ❌ | ✔️ |  |
| Navegador | ❌ | ✔️ |  |
| Nombre de la máquina | ❌ | ✔️ | Nombre de la máquina local en donde se ejecuta el programa. El valor debe ser dinámico, no un valor estático |