# 3. Convenciones Generales

## Orden del código

**Módulos**: Siempre trabajaremos con el sistema de Módulos de ECMAScript (ESM) en nuestro código. Aunque aún existen bibliotecas en CommonJS (CJS), podemos usarlas como módulos e importarlas sin usar la sintaxis de `require`.

**Evitar el entorno global**: Usemos las capacidades de los módulos para mantener nuestro entorno global limpio. No hay necesidad de declarar variables globales que ensucian todo y crean potenciales conflictos..

**Clases con propósito**: No creemos clases solo para encapsular un conjunto de variables y funciones, eso lo puede hacer mejor un módulo. Las clases deben cumplir un propósito de arquitectura, como implementar un patrón de diseño (di tu un _singleton_) o manejar un estado interno complejo y persistente.

## Una línea, una acción

Buscamos que cada línea de código tenga un propósito único y fácil de entender. Cuando una sola línea hace demasiadas cosas, se vuelve difícil de leer y peor de depurar. Por eso, preferimos la claridad sobre la concisión.

Esto explica porqué evitamos los ternarios anidados y usamos llaves en todos nuestros bloques de control (incluso en los `if` de una sola línea), lo que hace que el código sea predecible y reduce la posibilidad de errores a largo plazo.

## Nomenclatura

Una de las cosas más difíciles en la programación es asignar buenos nombres de forma consistente. La razón es simple: un buen nombre reduce la necesidad de explicaciones. Buscamos nombres que le digan a cualquiera lo que están viendo sin necesidad de comentarios.

- **Idioma**: Dado que los lenguajes de programación que usamos están en inglés, hemos acordado usar este idioma en nuestro código. Respetamos y nos gusta el idioma en el que hablamos pero el código en "espanglish" puede ser muy molesto y aumentar la carga cognitiva.

- **Variables y funciones**: Usamos **`camelCase`**. Los nombres de variables deben ser sustantivos que describan su contenido (ej., `userId`, `userName`), y los de las funciones, verbos que indiquen lo que hacen (ej., `fetchUsers`, `calculateTotal`, `getSomeShit`)... tener cuidado con palabras genéricas como `info` o `data` y cuando sea posible, optar por algo más descriptivo de la información que contienen.

- **Tipos, clases y componentes**: Usamos **`PascalCase`**. Esto ayuda a diferenciarlos del resto del código (ej., `UserType`, `ProductCard`).

- **Constantes de configuración**: Usamos **`SCREAMING_SNAKE_CASE`**. Son constantes que se usan para configurar un comportamiento del código, su nombre en mayúsculas debe dejar muy claro la info que contienen (ej., `API_URL`, `MAX_RETRIES`, `I_AM_A_MAGIC_NUMBER`).

## Bibliotecas Externas

Importar debe suceder solo cuando algo es realmente necesario. Evitamos importar por importar y nos aseguramos de que las bibliotecas que usamos estén bien mantenidas y sean de alta calidad.

Un ejemplo de lo que puede salir mal es el caso de **`left-pad`**. Una biblioteca con una función simple (no más de cinco líneas de código y bastante innecesaria si se conocen los métodos para `String`), que, al ser eliminada de NPM (Luego de eso se reforzó la política de no borrado de paquetes en NPM), causó que miles de proyectos dejaran de compilar. [El chisme completo](https://en.wikipedia.org/wiki/Npm_left-pad_incident).

**Cada dependencia es una responsabilidad.**

Por lo tanto:

- Solo importamos cuando la lógica del proyecto no depende de la importación.
- Solo importamos si hemos confirmado que no hay una forma directa o clara de realizar lo que necesitamos con nuestro propio código dentro del tiempo que disponemos.
- Solo importamos bibliotecas que tengan soporte activo (al menos un año).
- Solo importamos bibliotecas con tipado en TypeScript nativo para integrarlas mejor.

## Accesibilidad

Construir una interfaz de usuario no es solo cuestión de estética. La accesibilidad es fundamental para que nuestras aplicaciones puedan ser usadas por cualquier persona, considerando sus capacidades físicas, cognitivas, sociales, contextuales y tecnológicas.

**HTML Semántico**: Usa las etiquetas correctas (`<button>`, `<nav>`, `<article>`, ... ) en lugar de `<div>` como mantequilla en restaurante francés. El HTML semántico es clave para construir aplicaciones web accesibles desde el inicio, ayudando a los lectores de pantalla a entender la estructura de la página, facilitando la navegación con tecnologías asistivas y mejorando el SEO. [Aquí hay una pequeña guía](https://webdesign.solomon.ng/html-and-css/semantic-html/semantic-html.html).

**Atributos `aria-*`**: Una vez que nuestro documento está bien estructurado, los usuarios con tecnologías asistivas deben ser capaces de comprender los cambios que introducimos en el documento a través de las interacciones. Aquí es donde entra `aria-*`, que complementa lo que el HTML no cubre. Sin embargo, _no aria is better than wrong aria_ (Es mejor no tener aria a tener uno mal escrito). Si no entiendes el atributo, investiga antes de usarlo. [Esta es una buena introducción a ARIA](https://accessibilityfordevelopers.com/guide-to-aria/) y [aquí está la guía de MDN](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA), que es más amigable que las especificaciones de la W3C.

**Manejo de Foco**: Es clave que todo lo que se puede hacer con el _mouse_ también sea posible hacerlo con el teclado. Asegúrate de que los elementos sean enfocables y que el orden del foco sea lógico.

## El texto de la interfaz de usuario

Para facilitar el soporte, la internacionalización y las actualizaciones, se debe evitar "quemar" el texto directamente en el código. La práctica preferida es guardarlo en un archivo JSON, en la última carpeta común que use este texto, o al mismo nivel del directorio donde es usado. Así, tenemos una fuente única y consistente para el texto usado por el padre y todos sus hijos o todos los hermanos, y cualquier cambio de texto sucede en un solo lugar sin tener que modificar el código funcional.

## Comentarios solo cuando el código no lo explica todo

Idealmente, los nombres y la estructura de nuestro código deberían ser tan claros que hagan de los comentarios algo innecesario. Sin embargo, rara vez nuestro código alcanza ese nivel de "iluminación", y necesitamos explicar el _porqué_ de una solución. Comentemos lo menos posible y, cuando lo hagamos, sigamos estos parámetros:

**Solo lo esencial**: Los comentarios deben usarse para explicar la razón de una decisión, no lo que el código está haciendo.

**Etiquetas**: Usar etiquetas estandarizadas ayuda a que los comentarios sean fáciles de encontrar y den contexto a quien los lee en el futuro:

- **`NOTE:`**: Para dejar una nota importante.
- **`WARN:`**: Para advertir de un posible problema.
- **`HACK:`**: Para explicar soluciones temporales que deben ser atendidas pronto.
- **`TODO:`**: Para marcar una tarea pendiente.
- **`FIX:`**: Para indicar que algo está roto y necesita ser arreglado.

**Documentación (TSDoc)**: Úsalo solo para funciones y métodos que se exportan y son usados por otros archivos. Como regla general, piensa en qué información te gustaría tener disponible en las ventanas del LSP de tu editor de texto cuando escribes código. No es necesario explicar una función que solo es usada dentro del mismo archivo.

## Aduana: Importaciones y exportaciones

El orden de las importaciones es crucial para la legibilidad y una estructura consistente en todo nuestro codigo, el orden acordado es, primero las **bibliotecas externas** y dependencias de `node_modules`, como `leaflet` o `axios`, seguidas por los **módulos internos**, que son los archivos de nuestro _codebase_ (lo que hay dentro de `src/`), estos últimos siempre deben ser importados con rutas absolutas o alias.

Además, como equipo, evitamos las exportaciones `default` para tener un mejor seguimiento de los elementos. Esto nos asegura que siempre importemos con el nombre exacto (`import { Button } from '...'`), o que si cambiamos el nombre, sea de forma consciente, evitando confusiones.

### Importaciones Dinámicas

Evitamos las importaciones dinámicas (`import('someShit')`) a menos que haya una razón clara para hacerlo, como la optimización, rendimiento o _code splitting_, y en estos casos debe estar documentada la razón. Implementarla sin atención puede complicar el seguimiento de los módulos.

---
[Volver al menú principal](../frontend-structure.md) | [Siguiente: Buenas Prácticas en TypeScript](./4-buenas-practicas-en-typescript.md)
