# Tareas (*tickets*)
Se tendrán tareas para todas las actividades que involucren una de las siguientes consideraciones:
- Corresponde al diagnóstico o corrección de un error en una de las plataformas
- Corresponde a una investigación (*[spike]*) o a una prueba (*[POC]*) relacionada a algún compromiso de la línea
- Es una responsabilidad que tiene un resultado concreto (por ejemplo un PR, MR o un documento)

Ejemplos de actividades que no se manejan con tareas en el tablero del equipo:
- Apoyo en un proceso de selección (por ejemplo revisión de pruebas, hojas de vida o entrevistas)
- Apoyo en algún proceso o problema que tengan en otra línea (por ejemplo revisión de algún código, una consulta rápida en base de datos)
- Levantar un servicio caído
- Asistir a reuniones de futuros proyectos o convenios
- Tareas que surgen a partir de la supervisión de un contrato (a menos que sean actividades técnicas que tenemos que resolver, como dar acceso a alguien a un servidor o servicio)

Cabe aclarar que sí se debe crear una tarea si alguna de las actividades mencionadas en el punto anterior se extiende o complejiza.

## Creación

Normalmente será el líder técnico o encargado del proyecto quien cree las tareas, pero todos los miembros del equipo podrán hacerlo cuando sea necesario.

A continuación se presenta una guía para determinar en qué *pipeline* se debería crear:

1. Cuando se trata de un *bug* reportado por algún investigador, se discute con ellos la prioridad y se agrega o al *Backlog* o al *Sprint Backlog* con la prioridad discutida.
1. Cuando se trata de una mejora, deberá ir al *Backlog*.
1. Si es una actividad en la que se tuvo que trabajar sin previo aviso, pero del cuál se debe agregar registro (por ejemplo para poder asociar un *PR*), se debe agregar en *Todo* o en “*In Progress*”.

En cuanto al contenido de la tarea, se debe tener en cuenta lo siguiente para su creación:

1. Debe arrancar con un contexto que de claridad del por qué es necesaria esta tarea.
1. Debe tener una descripción que detalle el resultado esperado y las condiciones relacionadas a dicho resultado, esto puede estar acompañado de una lista de puntos para describir todo más fácilmente.
1. Cuando sea necesario, debe haber una sección de "Consideraciones" en donde se deben describir cosas a tener en cuenta para la tarea. Por ejemplo: archivos de prueba, consultas a otros investigadores, ayudas a TI.

Al crear las tareas, se deben asignar la etiquetas correspondientes al proyecto y tipo de producto al que pertenece, si hay dudas consultar con el líder técnico o encargado del proyecto.

## Desarrollo y cierre

* Al empezar a trabajar en una tarea, se debe pasar al pipeline “*In Progress*”. La tarea se mantendrá ahí a menos que por diferentes razones no se pueda seguir trabajando en ella, en cuyo caso pasará de nuevo a “*Todo*”.
* Cuando no es necesario realizar una tarea (empezar o terminar), se debe cambiar su estado a *Canceled*.
* Al crear un *PR* se debe asociar la tarea correspondiente. Esto automáticamente pasará la tarea al *pipeline* “*In Review”. De este estado solo vuelve a “*In Progress*” si los cambios solicitados son grandes.
* Tener en cuenta que al cerrar un PR asociado a una tarea, esta se marca automáticamente como completada (Estado *Done*), en algunos casos se deberá mantener abierta hasta finalizar otras cosas (por ejemplo documentación)
* Antes de cerrar una tarea se deben dejar comentarios que sean relevantes en el futuro. Por ejemplo, si se tomaron decisiones durante el desarrollo de la misma, discusiones que se hayan tenido, fuentes de información relevantes, modificaciones de alcance, entre otros. No se espera un detalle técnico, a menos que no haya código relacionado en el repositorio.

---
* volver al [inicio](/README.md)
* volver a las [normas de desarrollo](/docs/development-rules/README.md)
