import boto3
import os

# Configurar cliente S3 apuntando a LocalStack
s3 = boto3.client(
    "s3",
    endpoint_url="http://localhost:4566",
    aws_access_key_id="test",
    aws_secret_access_key="test",
    region_name="us-east-1"
)

bucket_name = "mi-bucket-raster"
download_folder = "descargas"

# Crear carpeta si no existe
os.makedirs(download_folder, exist_ok=True)

# Listar objetos en el bucket
response = s3.list_objects_v2(Bucket=bucket_name)
if 'Contents' in response:
    print("Archivos encontrados:")
    for obj in response['Contents']:
        key = obj['Key']
        print(f"- {key}")

        # Descargar archivo
        local_path = os.path.join(download_folder, os.path.basename(key))
        with open(local_path, 'wb') as f:
            s3.download_fileobj(bucket_name, key, f)
        print(f"Descargado: {local_path}")
else:
    print("No se encontraron archivos en el bucket.")
