# Virtual Machine for VPN setup

Configure a virtual machine to connect to a VPN (FortiNet) through a proxy for Linux systems

## References

- [redeszone.net](https://www.redeszone.net/tutoriales/servidores/vagrant-instalacion-configuracion-ejemplos/)
- [dev.to](https://dev.to/sannae/setting-up-windows-virtual-test-environments-with-vagrant-4k1b)
- [Vagrant Boxes](https://portal.cloud.hashicorp.com/vagrant/discover)

## Requirements

- `FortiClient` backup file with `.conf` extension.
- [VirtualBox](https://www.virtualbox.org/wiki/Downloads)
- [Vagrant](https://developer.hashicorp.com/vagrant/install)
- `corkscrew` (Optional) For SSH connections with proxies
- `sshpass` (Optional) For SSH connections with plain text passwords

## Setup

### Run the virtual machine

```sh
# Bring up your virtual machine
vagrant up
```

### Post installation steps

#### Open shared folder

Copy your `FortiClient` backup file in `./files` folder and follow these steps:

- Open `FortiClient VPN` in the virtual machine. Accept the initial message.
- Click on the `lock` button at the top right.
- Click the `gear` button at the top right.
- In `System`, click the `Restore` button and select your backup file in `C:\vagrant\files` path.
- Add the backup file, the password and clic the `Ok` button.

#### Add proxy in host

Add the automatic proxy file `http://192.168.56.10:8080/proxy.pac` in your network settings and/or web browser.

#### Add proxy in git

> Steps from [here](https://gist.github.com/evantoli/f8c23a37eb3558ab8765)

Add proxy in git for private git server.

```sh
# Add proxy by git server domain or IP
GIT_PRIVATE_SERVER=http://192.168.11.78
PROXY_SERVER=http://192.168.56.10:3128
git config --global "http.$GIT_PRIVATE_SERVER.proxy" $PROXY_SERVER
# Check global configuration
cat ~/.gitconfig
```

#### Add proxy in NMAP

```sh
nmap --proxies http://192.168.56.10:3128 $PRIVATE_DOMAIN_OR_IP
```

#### Add proxy for SSH connection

> `corkscrew` required for proxy setup
> `sshpass` required for connections with plain text passwords

Copy and modify the bash scripts [here](src/scripts/bash/).

## Useful commands

```sh
# Suspend VM
vagrant suspend
# Power off VM
vagrant halt
# Destroy VM
vagrant destroy
# Reload configuration from Vagrantfile
vagrant reload
# Make provioning
vagrant provision
```