# PAC (Proxy Auto-Config) scheduled task setup

# Set Execution Policy
Set-ExecutionPolicy Bypass -Force

# Variables
$taskName = "StartPACServer"
$proxyScriptPath = "C:\\files\PacServer.ps1"

# Check if the scheduled task already exists
if (Get-ScheduledTask -TaskName $taskName -ErrorAction SilentlyContinue) {
    Write-Host "Scheduled Task '$taskName' already exists. Skipping creation."
}
else {
    Write-Host "Scheduled Task '$taskName' does not exist. Creating..."
    $Action = New-ScheduledTaskAction -Execute "powershell.exe" -Argument "-ExecutionPolicy Bypass -File $proxyScriptPath"
    $Trigger = New-ScheduledTaskTrigger -AtStartup
    $Principal = New-ScheduledTaskPrincipal -UserId "SYSTEM" -RunLevel Highest
    $Settings = New-ScheduledTaskSettingsSet -AllowStartIfOnBatteries -DontStopIfGoingOnBatteries
    Register-ScheduledTask -TaskName $taskName -Action $Action -Trigger $Trigger -Principal $Principal -Settings $Settings
}

# Open port 8080 in Windows Firewall if not already open
if (-not (Get-NetFirewallRule -DisplayName "Allow Proxy PAC Server" -ErrorAction SilentlyContinue)) {
  New-NetFirewallRule -DisplayName "Allow Proxy PAC Server" -Direction Inbound -Protocol TCP -LocalPort 8080 -Action Allow
  Write-Host "Firewall rule created to allow inbound connections on port 8080."
}
else {
  Write-Host "Firewall rule 'Allow Proxy PAC Server' already exists. Skipping creation."
}