# Change timezone
tzutil /s "SA Pacific Standard Time"

# Add shortcuts
## Get the desktop path for the current user
$desktopPath = [Environment]::GetFolderPath("Desktop")
## PowerShell
### Create the shortcut path
$shortcutPath = Join-Path $desktopPath "PowerShell.lnk"
### Create the WScript.Shell COM object
$WshShell = New-Object -ComObject WScript.Shell
### Create the shortcut
$shortcut = $WshShell.CreateShortcut($shortcutPath)
### Set the target path to PowerShell
$shortcut.TargetPath = "C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe"
### Save the shortcut
$shortcut.Save()

# Change wallpaper
## Remove any set wallpaper
Set-ItemProperty -Path "HKCU:\Control Panel\Desktop" -Name "Wallpaper" -Value ""
## Force a solid color (e.g., black)
Set-ItemProperty -Path "HKCU:\Control Panel\Colors" -Name "Background" -Value "0 0 0"
## Refresh the desktop to apply wallpaper removal
RUNDLL32.EXE user32.dll,UpdatePerUserSystemParameters ,1 ,True

# Set dark mode for system and apps
## Change registry values
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize" -Name "AppsUseLightTheme" -Value 0
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize" -Name "SystemUsesLightTheme" -Value 0
## Restart explorer.exe
Stop-Process -Name explorer -Force
Start-Process explorer.exe

# Configure FQDN domain
Write-Host "Configure FQDN domain..."
$hostsPath = "$env:SystemRoot\System32\drivers\etc\hosts"
$fqdn = "windows-vpn.local"
$ip = "127.0.0.1"
$entry = "$ip`t$fqdn"

## Check if the entry already exists
$hostsContent = Get-Content $hostsPath
if ($hostsContent -notcontains $entry) {
    Add-Content -Path $hostsPath -Value $entry
    Write-Host "Added: $entry"
} else {
    Write-Host "The entry already exists"
}

# Restart computer
Write-Host "Restarting computer..."
Restart-Computer