#!/bin/bash

# Generate SSH tunnel using HTTP proxy

# Proxy server data
PROXY_SERVER=192.168.56.10
PROXY_PORT=3128
# SSH server data
SSH_SERVER=domain.com
SSH_USER=user
SSH_PORT=22
SSH_TUNNEL_LOCAL_PORT=80
SSH_TUNNEL_REMOTE_PORT=80
## Make a "ssh-data.txt" file with the plain text password in the first line
SSH_DATA=ssh-data.txt

# Make SSH tunnel with proxy
sshpass -f$SSH_DATA ssh -o ProxyCommand="corkscrew $PROXY_SERVER $PROXY_PORT %h %p" -o PreferredAuthentications=password -o PubkeyAuthentication=no -NL $SSH_TUNNEL_LOCAL_PORT:localhost:$SSH_TUNNEL_REMOTE_PORT -p "$SSH_PORT" $SSH_USER@$SSH_SERVER 