# Virtual Machine for Humboldt VPN setup 

Configuring a virtual machine to connect to the VPN through a proxy

## Requirements

- `FortiClient` backup file yor your user.

## Setup

### Vagrant

> Steps from [developer.hashicorp.com](https://developer.hashicorp.com/vagrant/install)

Install Vagrant in Ubuntu/Debian distros:

```sh
wget -O - https://apt.releases.hashicorp.com/gpg | sudo gpg --dearmor -o /usr/share/keyrings/hashicorp-archive-keyring.gpg
echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/hashicorp-archive-keyring.gpg] https://apt.releases.hashicorp.com $(lsb_release -cs) main" | sudo tee /etc/apt/sources.list.d/hashicorp.list
sudo apt update && sudo apt install vagrant
```

### VirtualBox

Install VirtualBox from [here](https://www.virtualbox.org/wiki/Downloads)

### Configure environment

> Some steps from [dev.to](https://dev.to/sannae/setting-up-windows-virtual-test-environments-with-vagrant-4k1b)

> Check vagrant boxes [here](https://portal.cloud.hashicorp.com/vagrant/discover)

```sh
# Create a Vagrantfile and initiate the box
vagrant init gusztavvargadr/windows-11 --box-version 2302.0.2409
```

Generate `Chocolatey` script from [here](https://chocolatey.org/install) and add the file in `src/scripts/InstallChocolatey.ps1` file.

Add the following lines in `Vagrantfile`:

```ruby
# VM setup
config.vm.provider "virtualbox" do |vb|
vb.name = "Windows-VPN"
vb.memory = 1024
vb.cpus = 1
end

# Enable UI
config.vm.provider "virtualbox" do |vb|
vb.gui = true
end

# Provisioning
## Run the external script to install Chocolatey
config.vm.provision "shell", path: "src/scripts/InstallChocolatey.ps1"
## Run the inline script to install forticlientvpn via Chocolatey
config.vm.provision "shell", inline: "choco install forticlientvpn --yes"
```

### Run the virtual machine

```sh
# Bring up your virtual machine
vagrant up
```

### Post installation steps

#### Open shared folder

Copy your `FortiClient` backup file in `./files` folder and follow these steps:

- Open `FortiClient VPN` in the virtual machine. Accept the initial message
- Click on the lock button at the top right
- Click the gear button at the top right
- In `System`, click the `Restore` button and select your backup file in `C:\vagrant\files` path
- Add the backup file password and clic the `Ok` button

## Useful commands

```sh
# Suspend VM
vagrant suspend
# Power off VM
vagrant halt
# Destroy VM
vagrant destroy
```