# Virtual Machine for Humboldt VPN setup 

Configuring a virtual machine to connect to the VPN through a proxy

## Setup

### Vagrant

> Steps from [developer.hashicorp.com](https://developer.hashicorp.com/vagrant/install)

Install Vagrant in Ubuntu/Debian distros:

```sh
wget -O - https://apt.releases.hashicorp.com/gpg | sudo gpg --dearmor -o /usr/share/keyrings/hashicorp-archive-keyring.gpg
echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/hashicorp-archive-keyring.gpg] https://apt.releases.hashicorp.com $(lsb_release -cs) main" | sudo tee /etc/apt/sources.list.d/hashicorp.list
sudo apt update && sudo apt install vagrant
```

### VirtualBox

Install VirtualBox from [here](https://www.virtualbox.org/wiki/Downloads)

### Configure environment

> Check vagrant boxes [here](https://portal.cloud.hashicorp.com/vagrant/discover)

```sh
# Create a Vagrantfile and initiate the box
vagrant init gusztavvargadr/windows-11 --box-version 2302.0.2409
# Bring up your virtual machine
vagrant up
```