# Change timezone
tzutil /s "SA Pacific Standard Time"

# Add shortcuts
## Get the desktop path for the current user
$desktopPath = [Environment]::GetFolderPath("Desktop")
## PowerShell
### Create the shortcut path
$shortcutPath = Join-Path $desktopPath "PowerShell.lnk"
### Create the WScript.Shell COM object
$WshShell = New-Object -ComObject WScript.Shell
### Create the shortcut
$shortcut = $WshShell.CreateShortcut($shortcutPath)
### Set the target path to PowerShell
$shortcut.TargetPath = "C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe"
### Save the shortcut
$shortcut.Save()

# Change wallpaper
## Remove any set wallpaper
Set-ItemProperty -Path "HKCU:\Control Panel\Desktop" -Name "Wallpaper" -Value ""
## Force a solid color (e.g., black)
Set-ItemProperty -Path "HKCU:\Control Panel\Colors" -Name "Background" -Value "0 0 0"

# Set dark mode for system and apps
## Change registry values
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize" -Name "AppsUseLightTheme" -Value 0
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize" -Name "SystemUsesLightTheme" -Value 0

# Configure taskbar
## Set taskbar aligment to left
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name 'TaskbarAl' -Value 0 -Type DWord -Force
## Remove copilot shortcup
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "ShowCopilotButton" -Value 0 -Type DWord -Force
## Remove search box
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Search" -Name "SearchBoxTaskbarMode" -Value 0 -Type DWord -Force
## Remove task view
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "ShowTaskViewButton" -Value 0 -Force
## Remove widgets
Get-AppxPackage *WebExperience* | Remove-AppxPackage