# Virtual Machine for VPN setup

Configure a virtual machine to connect to a VPN (FortiNet) through a proxy

## Requirements

- `FortiClient` backup file for your user in Windows.

## References

- [redeszone.net](https://www.redeszone.net/tutoriales/servidores/vagrant-instalacion-configuracion-ejemplos/)
- [dev.to](https://dev.to/sannae/setting-up-windows-virtual-test-environments-with-vagrant-4k1b)
- [Vagrant Boxes](https://portal.cloud.hashicorp.com/vagrant/discover)

## Setup

### Vagrant

> Steps from [developer.hashicorp.com](https://developer.hashicorp.com/vagrant/install)

Install Vagrant in Ubuntu/Debian distros:

```sh
wget -O - https://apt.releases.hashicorp.com/gpg | sudo gpg --dearmor -o /usr/share/keyrings/hashicorp-archive-keyring.gpg
echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/hashicorp-archive-keyring.gpg] https://apt.releases.hashicorp.com $(lsb_release -cs) main" | sudo tee /etc/apt/sources.list.d/hashicorp.list
sudo apt update && sudo apt install vagrant
```

### VirtualBox

Install VirtualBox from [here](https://www.virtualbox.org/wiki/Downloads)

### Run the virtual machine

```sh
# Bring up your virtual machine
vagrant up
```

### Post installation steps

#### Open shared folder

Copy your `FortiClient` backup file in `./files` folder and follow these steps:

- Open `FortiClient VPN` in the virtual machine. Accept the initial message
- Click on the lock button at the top right
- Click the gear button at the top right
- In `System`, click the `Restore` button and select your backup file in `C:\vagrant\files` path
- Add the backup file password and clic the `Ok` button

#### Enable proxy

In Windows, open the `squid` program from the Windows menu. Right clicking on `Squid Server` tray icon and select the option `Open Squid Configuration`.
Replace the file content with [this file](src/config/squid-proxy.conf)

> **NOTE:** Change your local network value in the file

Then, restart the `squid` service. Now, you can add the proxy url in your host!

##### Add proxy in host

```sh
# Add parameters
PROXY_ADDRESS=windows-vpn
PROXY_PORT=3128
# Test the proxy
curl -x http://$PROXY_ADDRESS:$PROXY_PORT -I http://www.google.com
```

## Useful commands

```sh
# Suspend VM
vagrant suspend
# Power off VM
vagrant halt
# Destroy VM
vagrant destroy
# Reload configuration from Vagrantfile
vagrant reload
```